#!/bin/sh

# pretrain
python pretrain.py 'cifar10' 'resnet110' 'models/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00' --batch 256 --noise_sd 1.00 --gpu 0 --lr_step_size 50 --epochs 150 --adv-training --num-steps 10 --epsilon 512 --train-multi-noise --num-noise-vec 2 --warmup 10 --noise_up 1.00 --noise_down 0.12

# select sigma for train set
python certify.py 'cifar10' --base_classifier 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/checkpoint.pth.tar' --name 'certified--train-n-500' --sigma_max 1.00 --sigma_min 0.12 --sigma_interval 0.05 --skip 1 --split 'train' --N 500 
python select_sigma_max.py --input 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/result-certified-n-500-train' --output 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00//train-label' --max 1.00 
python select_sigma_best.py --input 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/train-label' --output 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/train-label-distribution' --max 1.00 --min 0.12

# finetune
python finetune.py 'cifar10' 'resnet110' 'models/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00' --batch 256 --noise_sd 1.00 --gpu 0 --lr_step_size 50 --epochs 150 --adv-training --num-steps 10 --epsilon 512 --train-multi-noise --num-noise-vec 2 --sigma-weight 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/train-label-distribution' --pretrained-model 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/checkpoint.pth.tar' --lr 0.001

# certification
python certify.py 'cifar10' --base_classifier 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/checkpoint150.pth.tar' --name 'certified-test-n-1000' --sigma_max 1.00 --sigma_min 0.12 --sigma_interval 0.05 --skip 1 --split 'test' --N 1000 
python certify_10w.py 'cifar10' --base_classifier 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/checkpoint150.pth.tar' --name 'certified-test-n-10w' --skip 1 --iteration 20 --max_iter 20 --split 'test' --N 100000

# regions allocation
python regions_allocation.py --dataset 'cifar10' --file 'model/cifar10/resnet110/steps10/eps512/vec2/0.12-1.00/certified-test-n-10w'
